/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.ast;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.ast.Node;
import icyllis.flexmark.util.ast.NodeVisitor;
import icyllis.flexmark.util.ast.TextContainer;
import icyllis.flexmark.util.misc.BitFieldSet;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.Escaping;
import icyllis.flexmark.util.sequence.ReplacedTextMapper;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;

public class HtmlEntity
extends Node
implements TextContainer {
    @Override
    public void getAstExtra(@NotNull StringBuilder out) {
        if (!this.getChars().isEmpty()) {
            out.append(" \"").append(this.getChars()).append("\"");
        }
    }

    @Override
    @NotNull
    public BasedSequence[] getSegments() {
        return EMPTY_SEGMENTS;
    }

    public HtmlEntity() {
    }

    public HtmlEntity(BasedSequence chars) {
        super(chars);
    }

    @Override
    public boolean collectText(ISequenceBuilder<? extends ISequenceBuilder<?, BasedSequence>, BasedSequence> out, int flags, NodeVisitor nodeVisitor) {
        if (BitFieldSet.any(flags, F_NODE_TEXT)) {
            out.append(this.getChars());
        } else {
            ReplacedTextMapper textMapper = new ReplacedTextMapper(this.getChars());
            BasedSequence unescaped = Escaping.unescape(this.getChars(), textMapper);
            out.append(unescaped);
        }
        return false;
    }
}

